	.title  "Kosbar AC01 Initilization Program"
	.list
	.width 86
	.length 32000
*					  
***************************************************************
* Program:	Analog Interface Chip Initialization - rev 3 
* Description:  This subroutine will initialize the analog
*		interface chip (AC01), which contains an 
*		A/D and D/A converter.
* Date: 	9/8/98
*
* This File:     	acini.asm
* External Files: 	
* Lables Defined:	reg1, reg2, reg3, reg4, reg5, reg6
*			reg7, reg8, acinit, req2
* External Labels Used:	
* Label at Entry Point:	acinit
***************************************************************
*
***************************************************************
* register Setting for AC01 chip
***************************************************************
*
* Look at AC01 documentation for a description of Reg1-8
*
reg1	.set	124h	;FCLK = 138.888 kHz,
			;anti-alising filter cutoff 3.472 kHz
reg2	.set	20fh	;Samp Freq = 9.259 kHz
reg3	.set	300h	;A' register not used
reg4	.set	41Dh	;Analog Input Gain = 12 dB (max)
			;Analog Output Gain = 0 dB (max)
			;Monitor Gain = 0 dB (max)
reg5	.set	501h	;Input High Pass Filter enabled
			;Input from IN pins
reg6	.set	600h	;Not used
reg7	.set	700h	;Not used
reg8	.set	801h	;Not used
*
***************************************************************
* Executable Code to Initizlize chip
***************************************************************
*
acinit:
	xf = 0		; Reset AC01
	intm = 1	; Disable Interrupts
	tcr = #10h	; Stop Timer
	imr = #280h	; Unmask TXINIT and HPINIT
	tspc = #0008h	; Stop TDM Serial Port
	tdxr = #0h	; Send a 0 to Serial Port
	tspc = #00c8h	; Reset and start the serial port
	xf = 1		; Let AC01 run
*
***************************************************************
* Send data to registers on AC01 chip
***************************************************************
*
	a = #reg1	;Load accumulator with value of reg1
	call req2	;Send value to AC01 chip
*
	a = #reg2
	call req2
*
	a = #reg3
	call req2
*
	a = #reg4
	call req2
*
	a = #reg5
	call req2
*
	a = #reg6
	call req2
*
	a = #reg7
	call req2
*
	a = #reg8
	call req2
	return
*
***************************************************************
* Subroutine to send accumulator value to AC01 chip
***************************************************************
*
req2:
	ifr = #080h	; Clear TDM Xmit Interrup Request
	tdxr = #03h	; Prep AC01 for a control word
	idle(1) 	; Wait for serial port to send data
	tdxr = a	; Send data to AC01 chip
	ifr = #080h	; clear interrupt request
	idle(1)		; Wait for serial port to send data
	tdxr = #0h	; Send 0h to clear D/A
	ifr = #080h	; Clear TDM Xmit Interrup Request
	idle(1)		; Wait for serial port to send data
	return		; return from subroutine