% generate.m 
% This generates the table for a periodic waveform
%
% In main.asm, BK should be changed to match length of
%   waveform, and step size should be changed as desired
%
%	By default, BK=length of t shown below

t=1:100;	% number of samples in waveform
B=sqrt(t);

fid = fopen('coeff.asm','w');
fprintf(fid,'* Filter Coefficients Generated by Matlab Script\n');

Bbit=log2(max(abs(B)))
B=2^(13-round(Bbit))*B;
B=round(B);


fprintf(fid,'h%d\t.word\t%d\n',1,B(1));
for i=2:length(B)-1
   fprintf(fid,'\t.word\t%d\n',B(i));
end;
fprintf(fid,'h%d\t.word\t%d\n',length(t),B(length(t)));
fclose(fid);
disp('File coeff.asm generated');
