	.title  "Kosbar Interrupt Service Routine Vectors"
	.list
	.width 86
	.length 32000
*					  
***************************************************************
* Program:	Interrupt Service Routine Vector Table - rev 2
* Description:  A series of branch statements that will be
* 		taken when an interrupt becomes active
* Date: 	9/8/98
*
* This File:     	isrv.asm
* External Files: 	
* Lables Defined:	reset, nmi, trap2, swi18, swi19, swi20
*			swi21, swi22, swi23, swi24, swi25
*			swi26, swi27, swi28, swi29, swi30
*			int0, int1, int2, int3, tint, brint
*			bxint, trint, txint, hpiint
* External Labels Used:	ad_isr, da_isr
* Label at Entry Point:	*** NONE ***
***************************************************************
*
reset	goto  #80h	;00 RESET  * DO NOT MODIFY *
	nop
	nop
nmi	return_enable	;04 non-maskable external interrupt
	nop
	nop
	nop
trap2	goto  #88h	;08 trap2/swi17 * DO NOT MODIFY *
	nop
	nop
swi18	return_enable	;0C software interrupt 18
	nop
	nop
	nop
swi19	return_enable	;10 software interrupt 19
	nop
	nop
	nop
swi20	return_enable	;14 software interrupt 20
	nop
	nop
	nop
swi21	return_enable	;18 software interrupt 21
	nop
	nop
	nop
swi22	return_enable	;1C software interrupt 22
	nop
	nop
	nop
swi23	return_enable	;20 software interrupt 23
	nop
	nop
	nop
swi24	return_enable	;24 software interrupt 24
	nop
	nop
	nop
swi25	return_enable	;28 software interrupt 25
	nop
	nop
	nop
swi26	return_enable	;2C software interrupt 26
	nop
	nop
	nop
swi27	return_enable	;30 software interrupt 27
	nop
	nop
	nop
swi28	return_enable	;34 software interrupt 28
	nop
	nop
	nop
swi29	return_enable	;38 software interrupt 29 (reserved)
	nop
	nop
	nop
swi30	return_enable	;3C software interrupt 30 (reserved)
	nop
	nop
	nop
int0	 return_enable	;40 external user interrupt 0
	nop
	nop
	nop
int1	 return_enable	;44 external user interrupt 1
	nop
	nop
	nop
int2	 return_enable	;48 external user interrupt 2
	nop
	nop
	nop
tint 	return_enable	;4C internal timer
	nop
	nop
	nop
brint	return_enable	;50 Buffered Serial Port Receive
	nop
	nop
	nop
bxint	return_enable	;54 Buffered Serial Port Transmit
	nop
	nop
	nop
trint	dgoto ad_isr	;58 TDM Serial Port Receive
	nop
	nop
txint	dgoto da_isr	;5C TDM Serial Port Transmit
	nop
	nop
int3	return_enable	;60 external user interrupt 3
	nop
	nop
	nop
hpiint	goto #0e4h	;64; HPI * DO NOT MODIFY *
	nop
	nop
*
***************************************************************
* Reserved Space from 68 to 7F 
***************************************************************
*
	.space  24*16
