        .title  "Randy Dimmett - Periodic waveform"
        .list
        .width 86
        .length 32000
*
***************************************************************
* Program:      Randy Dimmett - Periodic waveform
* Description:  This program wil generate a periodic waveform
*
* Date:         12/99
*
* This File:            main.asm
* External Files:       isrv.asm, acinit.asm
* External Labels Used: acinit
* Label at Entry Point: start
*
*
***************************************************************
*
***************************************************************
* Sections
***************************************************************
*
	.setsect ".text",0x1800,0	; Program
	.setsect "data",0x0200,1	; Data
	.setsect "intvecs",0x0180,0	; Interrupt Vectors
*
***************************************************************
* Interrupt Service Routine Vectors
***************************************************************
*
	.sect "intvecs"
	.copy "isrv.asm"
*
***************************************************************
* Main Program
***************************************************************
*
	.sect ".text"
start:
	intm = 1
	sp = #0ff0h
	dcall acinit
	DP = #0
	nop
	pmst = #01a0h
	imr = #240h
	OVM = 0	
	ASM = #0
	intm = 0
	; Edit these to your liking
        AR0=#0x1	; Step Size
        AR2=#0x200	; Starting location
        BK=#100		; Samples in waveform
loop:	nop
	goto loop
*
***************************************************************
* Initialization Routine for Analog Interface Chip
***************************************************************
*
	.copy "acinit.asm"
*
***************************************************************
* A to D Interrupt Service Routine
***************************************************************
*
ad_isr:	A = TRCV	; get input signal from A/D
	A = *AR2+0% 	; Get sample from lookup table
	A=#0xFFFC & A;	  Keep D/A out of setup mode.
	TDXR = A	; Send lower 16 bits to D/A
	return_enable	; End of ISR routine
	nop
	nop
*
***************************************************************
* D to A Interrupt Service Routine
***************************************************************
*
da_isr:
	return_enable   ; Return to waiting loop
	nop
	nop
*
***************************************************************
* Reserved Space for input data
***************************************************************
*
         .sect "data"
h_sig	.include "coeff.asm" ; Include Matlab generated coeff
*
***************************************************************
* End of File
***************************************************************
*
	.end
