	.title  "Randy Dimmett HW 3"
	.list
	.width 86
	.length 32000
*
***************************************************************
* Program:	Randy Dimmett HW 3
* Description:  echo
* Date: 	12/99
*
* This File:     	main.asm
* External Files: 	isrv.asm, acinit.asm
* Lables Defined:	start, loop, ad_isr, da_isr
* External Labels Used:	acinit
* Label at Entry Point:	start
***************************************************************
*
***************************************************************
* Sections
***************************************************************
*
	.setsect ".text",0x1800,0	; Program
	.setsect "data",0x0200,1	; Data
	.setsect "intvecs",0x0180,0	; Interrupt Vectors
*
***************************************************************
* Interrupt Service Routine Vectors
***************************************************************
*
	.sect "intvecs"
	.copy "isrv.asm"
* Change M here:
M	.word	3936
temp	.word	M+0x1890
*
***************************************************************
* Main Program
***************************************************************
*
	.sect ".text"
start:
	intm = 1
	sp = #0ff0h
	dcall acinit
	DP = #0
	nop
	pmst = #01a0h
	imr = #240h
	OVM = 0	
	ASM = #0
	intm = 0
        AR3=#0x1890
loop:	nop
	goto loop
*
***************************************************************
* Initialization Routine for Analog Interface Chip
***************************************************************
*
	.copy "acinit.asm"
*
***************************************************************
* A to D Interrupt Service Routine
***************************************************************
*
ad_isr:	A = TRCV	; get input signal from A/D
	*AR4=A
	T=@bcoeff
	B=T * *AR4	; multiply by b coefficient
	B=B>>14
        (*AR3+)=B
        B=#0
        B=AR3
        B+=#5
        AR5=B		; AR5 is a little ahead of AR3
        B-=@temp	; this is defined by M
        if (BLT) goto donothing
        AR3=#(0x1890) ; reset AR3
donothing:
	T=@acoeff
	A=T * *AR4	; multiply by a coefficient
	A=A>>14
        A=A+*AR5	
	A=#0xFFFC & A;	  Keep D/A out of setup mode.
	TDXR = A	; Send lower 16 bits to D/A
	return_enable	; End of ISR routine
	nop
	nop
*
***************************************************************
* D to A Interrupt Service Routine
***************************************************************
*
da_isr:
	return_enable   ; Return to waiting loop
	nop
	nop
*
***************************************************************
* Reserved Space for input data
***************************************************************
*
         .sect "data"
	.copy "coeff.asm"
*
***************************************************************
* End of File
***************************************************************
*
	.end
