	.title  "problem 5"
	.list
	.width 86
	.length 32000
*
***************************************************************
* Program:	FIR Filter program
* Description:  A simple program that implements an FIR
*		filter.
* Date: 	
*
* This File:     	main.asm
* External Files: 	isrv.asm, acinit.asm
* Lables Defined:	start, loop, ad_isr, da_isr
* External Labels Used:	acinit
* Label at Entry Point:	start
***************************************************************
*
***************************************************************
* Sections
***************************************************************
*
	.setsect ".text",0x1800,0	; Program
	.setsect "data",0x0200,1	; Data
	.setsect "intvecs",0x0180,0	; Interrupt Vectors
*
***************************************************************
* Interrupt Service Routine Vectors
***************************************************************
*
	.sect "intvecs"
	.copy "isrv.asm"
*
***************************************************************
* Main Program
***************************************************************
*
	.sect ".text"
start:
	intm = 1
	sp = #0ff0h
	dcall acinit
	DP = #0
	nop
	pmst = #01a0h
	imr = #240h
	OVM = 0	
	ASM = #0
	@temp1 = #0
	intm = 0
loop:	nop
	goto loop
*
***************************************************************
* Initialization Routine for Analog Interface Chip
***************************************************************
*
	.copy "acinit.asm"
*
***************************************************************
* A to D Interrupt Service Routine
***************************************************************
*
ad_isr:	A = TRCV	; get input signal from A/D
* IIR PART
	DP=#in_sig_startB; set DP to page with delay line
	@in_sig_startB=A;  store input in delay line
	AR0=#in_sig_endB;  Set AR0 to point to end of delay line
	A=#0;             Clear accumulator
	repeat(#2);      Do the next instruction this many times
	macd(*AR0-,b0,A); Execute filter
	AR2=#60h
        dbl(*AR2+)=A	; store IIR filter part
* FIR PART
        A=A>>15
        A=A>>7
        A=A+@temp1
        DP=#in_sig_startA; set DP to page with delay line
	@in_sig_startA=A;  store input in delay line
	AR1=#in_sig_endA;  Set AR0 to point to end of delay line
	A=#0;             Clear accumulator
	repeat(#2);      Do the next instruction this many times
	macd(*AR1-,a0,A); Execute filter
	A=A>>3
	AR4=#60h;		; Get old A
	B = dbl(*AR4+);
        B=B>>15
        B=B>>7
        @temp1=B	; Store start of next FIR part
	A = A + B;
	A=A>>9
	A=#0xFFFC & A;	  Keep D/A out of setup mode.
	TDXR = A	; Send lower 16 bits to D/A
	return_enable	; End of ISR routine
	nop
	nop
*
***************************************************************
* D to A Interrupt Service Routine
***************************************************************
*
da_isr:
	return_enable   ; Return to waiting loop
	nop
	nop
*
***************************************************************
* Reserved Space for input data
***************************************************************
*
         .sect "data"
in_sig_startB	.space  2*16 ; reserve space for delay line
in_sig_endB	.space 1*16   ; last word in delay line
bitbucketB	.space 1*16   ; don't put anything here
in_sig_startA	.space  2*16 ; reserve space for delay line
in_sig_endA	.space 1*16   ; last word in delay line
bitbucketA	.space 1*16   ; don't put anything here
*
***************************************************************
* Reserved Space for input data
***************************************************************
*
h_sig	.include "coeff.asm" ; Include Matlab generated coeff
temp1	.word	0; a temporary memory location
*
***************************************************************
* End of File
***************************************************************
*
	.end
