% Designing a band pass filter for the TI 'C54x chip
% FIR filter algorithm
close all;
clear all; clf;
fc=1000;
fs=9259;
Fp=[1000 2000]; Fs=[700 2500]; Gp=3; Gs=40;
Fp=Fp/(fs/2); 
Fs=Fs/(fs/2);
[n,Fn]=cheb1ord(Fp,Fs,Gp,Gs);
[b,a]=cheby1(1,Gp, Fn);

hz=freqz(b,a,1024);
freq=1:fs/(2*1024):fs/2;
plot(freq,20*log10(abs(hz)+1E-10));
grid on;
zoom on;
figure;
plot(freq,(abs(hz)));
grid on;
zoom on;

% Write results to a data file, in a way that is easy to
% include in .asm files
fid = fopen('coeff.asm','w');
fprintf(fid,'* Filter Coefficients Generated by Matlab Script\n');

imp=[1:10000]*0;
imp(1)=1;

Bbit=log2(max(abs(b)));
scaleB=(15-ceil(Bbit))
B=2^scaleB*b;
B=round(B);

Abit=log2(max(abs(a)));
scaleA=(14-ceil(Abit))
A=2^scaleA*a;
A=-1*round(A);

GainB=max(abs(freqz(b,1,imp)));
GainA=max(abs(freqz(1,a,imp)));
GainTot=max(abs(freqz(b,a,imp)));

for i=1:length(B)
   fprintf(fid,'b%d\t.word\t%d\n',(i-1),B(i));
end;
   fprintf(fid,'a%d\t.word\t%d\n',0,0);
for i=2:length(A)
   fprintf(fid,'a%d\t.word\t%d\n',(i-1),A(i));
end;
fclose(fid);
disp('File coeff.asm generated');