	.title  "EE301C Project"
	.list
	.width 86
	.length 32000
*
***************************************************************
* Program:	EE301C Project -- Network Analizer
* Author: Josh Horton
* This File:     	main.asm
* External Files: 	isrv.asm, acinit.asm script.asm
* Lables Defined:	start, loop, ad_isr, da_isr, sine
*			done, no_wrap
* External Labels Used:	acinit
* Label at Entry Point:	start
*
***************************************************************
* Set up the chrip
***************************************************************
*
*
fr_start	.set		100	; Set to starting frequency
*
***************************************************************
* Sections
***************************************************************
*
	.setsect ".text",0x1800,0	; Program
	.setsect "data",0x0200,1	; Data
	.setsect "intvecs",0x0180,0	; Interrupt Vectors
*
***************************************************************
* Set memory locations to store program data
***************************************************************
*
	.sect "data"
deltah		.word		0	; Stores current delta step value
deltal 		.word		0
inch		.word		0	; Stores current increment value
incl		.word		0
wrapcnt		.word		0	; Wrap counter
cyc_cnt		.word		0	; Count number of cycles before
					; step increase
prvcos		.word		0	; Previous cosine value
prvsin		.word		0	; Previous sine value
cossum		.word		0	; Temp sum of cosines
sinsum		.word 		0	; Temp sum of sines
*
***************************************************************
* Interrupt Service Routine Vectors
***************************************************************
*
	.sect "intvecs"
	.copy "isrv.asm"
*
***************************************************************
* Main Program
***************************************************************
*
	.sect ".text"
start:
	intm = 1				; Turn off interrupts
	DP = #wrapcnt
	@(wrapcnt) = #(1000)
	@(inch) = #0
	@(incl) = #0
	@(deltah) = #(1159603*fr_start/327680);
	@(deltal) = #(1159603*fr_start/10-1159603*fr_start/10);
	@(cyc_cnt) = #10;
	SP = #0ff0h
	dcall acinit
	DP = #0
	nop
	PMST = #01a0h
	SXM = #1		; Turn on sine extension mode
	IMR = #240h
	OVM = 0	
	ASM = #0
	AR2=#(0x2680)	; Start of look-up table
	AR4=#(0x1920)	;Starting address output freq resp.
	AR5=#(0x2670)	;Starting address output freq resp.
	AR1=#(0x2671)	;Starting address output freq resp.
	repeat(#0xFF)	; Fill look-up table with 256 words
	(*AR2+)=prog(0xFE00) 	; Move from prog ROM to data RAM
	repeat(#128)	; Fill look-up table with 256 words
	(*AR2+)=prog(0xFE00) 	; Move from prog ROM to data RAM
	AR2=#(0x2680)	; Start of look-up table
	@(prvcos) = #0
	@(prvsin) = #0
	@(cossum) = #0
	@(sinsum) = #0
	intm = 0
loop:	nop
	goto loop
*
***************************************************************
* Initialization Routine for Analog Interface Chip
***************************************************************
*
	.copy "acinit.asm"
*
***************************************************************
* A to D Interrupt Service Routine
***************************************************************
*
ad_isr:
*
* These are the registers affected by the ISR -- push them on the stack
* to keep them from disturbing the main program
*
	push(AR1)
	push(AL)
	push(AH)
	push(AG)
	push(BL)
	push(BH)
	push(BG)
*
* @61 contains previous cosine value
* @62 contains previous sine value
* @67 contains new value from input
*
	A = TRCV	; Clear out receive interrupt
	;DP=#0
        T=@(prvcos)	; For multiplying by cosine
        @(67h)=A
        A=T*@(67h)
	A=A>>15
	B=@(cossum)	; B contains previous sum
        A=A+B
        ;A=|A|
        @(cossum)=A
        T=@(prvsin)	; For multiplying by sine
        B=T*@(67h)	
	B=B>>15
        A=@(sinsum)
        B=B+A
        ;B=|B|
        @(sinsum)=B
*
* Now the sum is finished and stored
* Now do sqrt of the sum of the squares,
*  but only if we have enough cycles stored up.
*
        A = @(cyc_cnt)
	if (AGT) goto donothing
        A=@(cossum)
        B=@(sinsum)
        A=|A|
        B=|B|
*
* Find the max and min values
*
        A=A-B
        if(ALT) goto hypot; 
        A=@(sinsum)
        B=@(cossum)
        B=|B|
hypot:		; calculate sqrt of sum of sqrs
        A=@(cossum)
        A=|A|
*
* Now A should contain minimum
* B should contain maximum
*
        A=A>>1		; Divide min by two
        A=A+B;          ; Add 1/2 min and max
        (*AR4+)=B
        nop
        @(cossum)=#0
        @(sinsum)=#0
donothing:
        A=#0
        B=#0
*
***************************************************************
* Chirp
***************************************************************
*
chirp:	
	DP = #deltah		;  Set to chirp page	
	B = @(deltah) << 15
	B = B + @(deltal)
	A = @(cyc_cnt)
	if (AGT) goto samestep
	B = B + #0x7fff << 4 	;  Increase step freq
samestep:
	A = B & #0x7FFF
	@(deltal) = A
	A = B << (-15)
	A = A & #0x7FFF
	@(deltah) = A
	A = @(inch) << 15	; Put the high and low part of the 
	A = A + @(incl)		; increment into the accumulator
	A = A + B
*
* Are we at the end of the table if so wrap around if not don't wrap	
*
	B = A << -16;
	B = B - #(0x3FFF);
	if (BLEQ) goto no_wrap
	  B = B << 15;
	  B = B << 1;
	  A = A & #(0x0FFFF);
	  A = A | B;
	  B = @(cyc_cnt)
	  if (BGT) goto cycrst
          @(wrapcnt) -= 10	; Increment sample counter
	  @(cyc_cnt)=#300;	; Reset cycle counter
cycrst:	  @(cyc_cnt) -= 1;
no_wrap:			; If we are not wrapping save counter value
	B = A & #0x7FFF
	@(incl) = B
	B = A << (-15)
	B = B & #0x7FFF
	@(inch) = B
* Find the output value
	B = A << (-11)
	B = B << (-11)
	A = #0x2680 + B	; Add interpolated value to starting phase (broken)
	AR2 = A		; Load the contents of AR2 into A
	A = *AR2
	@(prvsin)=*AR2
	AR3=AR2
	B=AR3
	B=B+#64		; Find the 90 degree shift value
	AR3=B
        @(prvcos)=*AR3
	nop
	nop
	A = A & #0xFFFC 	; Make 2 LSB 00 for AC01 
	TDXR = A		; Send lower 16 bits to D/A
*	
	B=@(wrapcnt)
	if (BGEQ) goto no_reset		;  Skip if samples < tot_samp
        AR4=#(0x1920);
	  @(wrapcnt) = #(1000)	;  Reset frequency, samp counter
	  @(deltah) = #(1159603*fr_start/327680)
	  @(deltal) = #(1159603*fr_start/10-1159603*fr_start/327680)	
*
no_reset:
*		Return altered CPU registers to original value
*
	BG = pop()
	BH = pop()
	BL = pop()
	AG = pop()
	AH = pop()
	AL = pop()
	AR1 = pop()
*
	return_enable	; End of ISR routine
	nop
	nop
*
***************************************************************
* D to A Interrupt Service Routine
***************************************************************
*
da_isr:
	return_enable   ; Return to waiting loop
	nop
	nop
*
***************************************************************
* End of File
***************************************************************
*
	.end