	.title  "EE301C Project"
	.list
	.width 86
	.length 32000
*
***************************************************************
* Program:	EE301C Project -- Network Analizer
* Author: Josh Horton
* This File:     	main.asm
* External Files: 	isrv.asm, acinit.asm script.asm
* Lables Defined:	start, loop, ad_isr, da_isr, sine
*			done, no_wrap
* External Labels Used:	acinit
* Label at Entry Point:	start
*
***************************************************************
* Set up the chrip
***************************************************************
*
*
fr_start	.set		100	; Set to starting frequency
fr_finish	.set		2000	; Set to final frequency
time		.set		70	; Time in tenths of a second
*
***************************************************************
* Sections
***************************************************************
*
	.setsect ".text",0x1800,0	; Program
	.setsect "data",0x0200,1	; Data
	.setsect "intvecs",0x0180,0	; Interrupt Vectors
*
***************************************************************
* Set memory locations to store program data
***************************************************************
*
	.sect "data"
deltah		.word		0	; Stores current delta step value
deltal 		.word		0
phshift		.word		0	; Phase shift for sine signal
inch		.word		0	; Stores current increment value
incl		.word		0
wrapcnt		.word		0	; Wrap counter
tot_samp	.word		0	; Number of samples in a chirp
step_inc	.word		0	; Step increment
*
***************************************************************
* Interrupt Service Routine Vectors
***************************************************************
*
	.sect "intvecs"
	.copy "isrv.asm"
*
***************************************************************
* Main Program
***************************************************************
*
	.sect ".text"
start:
	intm = 1				; Turn off interrupts
	DP = #wrapcnt
	@(wrapcnt) = #(-32767)
	@(inch) = #0
	@(incl) = #0
	@(tot_samp) = #(time*9259/10-32767);
	@(step_inc) = #((fr_finish-fr_start)*12524/(100*time));
	@(deltah) = #(1159603*fr_start/327680);
	@(deltal) = #(1159603*fr_start/10-1159603*fr_start/327680*32768);
	@(phshift) = #(90*256/360);
	SP = #0ff0h
	dcall acinit
	DP = #0
	nop
	PMST = #01a0h
	SXM = #1		; Turn on sine extension mode
	IMR = #240h
	OVM = 0	
	ASM = #0
	AR3=#(0x1800)	;Starting address of lookup-table
	AR4=#(0x1900)	;Starting address of lookup-table
	AR2=#(0x2700)	; Start of look-up table
	repeat(#0xFF)	; Fill look-up table with 256 words
	(*AR2+)=prog(0xFE00) 	; Move from prog ROM to data RAM
	intm = 0
loop:	nop
        A=#0
        B=AR3
        B-=#0x1820 
        if (BLT) goto donothing
        AR3=#(0x1800) ; reset AR3
	repeat(#0x1F)	; add up the values stored
        A=A+*AR3+	; add up all numbers in a cycle
        AR3=#(0x1800) ; reset AR3
        nop
        nop
        A=A>>15
        (*AR4+)=A
        nop
donothing:
	goto loop
*
***************************************************************
* Initialization Routine for Analog Interface Chip
***************************************************************
*
	.copy "acinit.asm"
*
***************************************************************
* A to D Interrupt Service Routine
***************************************************************
*
ad_isr:
*
* These are the registers affected by the ISR -- push them on the stack
* to keep them from disturbing the main program
*
	push(AR2)
	push(AR1)
	push(AL)
	push(AH)
	push(AG)
	push(BL)
	push(BH)
	push(BG)
*
	A = TRCV	; Clear out receive interrupt
        T=@(0x0061)
        @(67h)=A
        A=T*@(67h)	
        A=A>>14
        *AR3=A
        B=AR3
        B=B+#1
        AR3=B 	
*
***************************************************************
* Chirp
***************************************************************
*
chirp:	
	DP = #deltah		;  Set to chirp page	
	B = @(deltah) << 15
	B = B + @(deltal)
	B = B + @(step_inc);
	A = B & #0x7FFF
	@(deltal) = A
	A = B << (-15)
	A = A & #0x7FFF
	@(deltah) = A
	A = @(inch) << 15	; Put the high and low part of the 
	A = A + @(incl)		; increment into the accumulator
	A = A + B
*
* Are we at the end of the table if so wrap around if not don't wrap	
*
	B = A << -16;
	B = B - #(0x3FFF);
	if (BLEQ) goto no_wrap
	  B = B << 15;
	  B = B << 1;
	  A = A & #(0x0FFFF);
	  A = A | B;
no_wrap:			; If we are not wrapping save counter value
	B = A & #0x7FFF
	@(incl) = B
	B = A << (-15)
	B = B & #0x7FFF
	@(inch) = B
* Find our output value
	B = A << (-11)
	B = B << (-11)
	A = #0x2700 + B	; Add interpolated value to starting phase (broken)
	AR2 = A		; Load the contents of AR2 into A
	nop			; Pipeline Confilct?
	nop
	A = *AR2		; Find the value in the lookup table
	@(0x0061)=A		; Store value
	A = A & #0xFFFC 	; Make 2 LSB 00 for AC01 
	TDXR = A		; Send lower 16 bits to D/A
*
	@(wrapcnt) += 1	; Increment sample counter
	nop
*
	B = @(tot_samp)
	B = B - @(wrapcnt)
	if (BGEQ) goto no_reset		;  Skip if samples < tot_samp
        AR4=#(0x1900);
	  @(wrapcnt) = #(-32767)	;  Reset frequency, samp counter
	  @(deltah) = #(1159603*fr_start/327680)
	  @(deltal) = #(1159603*fr_start/10-1159603*fr_start/327680)	
*
no_reset:
*		Return altered CPU registers to original value
*
	BG = pop()
	BH = pop()
	BL = pop()
	AG = pop()
	AH = pop()
	AL = pop()
	AR1 = pop()
	AR2 = pop()
*
	return_enable	; End of ISR routine
	nop
	nop
*
***************************************************************
* D to A Interrupt Service Routine
***************************************************************
*
da_isr:
	return_enable   ; Return to waiting loop
	nop
	nop
*
***************************************************************
* End of File
***************************************************************
*
	.end
