% Network Analyzer Simulation
%
% Josh Horton
% Randy Dimmett

close all;
clear all;

fs=9259;
fc=1500;	% cuttoff freq.
Wn=fc/(fs/2)

[B,A]=butter(2,Wn,'high');
%freqz(B,A)

t=0:1/fs:.05;
t1=t(length(t));
p=1; % for linear    
Envout=[];
Phaseout=[];

for freq=0:5:3000;
   beta = (freq).*(t1.^(-p));

  c = cos(2*pi * ( beta./(1+p).*(t.^(1+p))));
  s = sin(2*pi * ( beta./(1+p).*(t.^(1+p))));
  
  ADinput=filter(B,A,c);
  ADI = ADinput .* c;
  ADQ = ADinput .* s;

SUMI=abs(sum(ADI));
SUMQ=abs(sum(ADQ));

realOut=sqrt(SUMI^2+SUMQ^2);
ApproxOut=max([SUMI SUMQ])+min([SUMI SUMQ])/2;
Envout=[Envout ApproxOut];
Phase=atan(SUMI./SUMQ);
Phaseout=[Phaseout Phase];

end

%sound(ADinput);
plot(10*log10(Envout));
figure
freqz(B,A);
figure
plot(Phaseout);